unit uWBModule;

interface

uses
  SysUtils, Classes, HTTPApp, HTTPProd;

type
  TWebModule1 = class(TWebModule)
    PageProducer1: TPageProducer;
    PageProducer2: TPageProducer;
    procedure WebModule1waHelloWorldAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule1action2Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    sNome, sendereco : string;
  end;

var
  WebModule1: TWebModule1;

implementation

{$R *.xfm}

procedure TWebModule1.WebModule1waHelloWorldAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.Content := Format('<html><center><h1> Ol Mundo "ActiveDelphi" !</h1><br> <h3> Seja bem vindo, hoje : %s </h3><form name "form1" action="/exemplo2/action1" method="post"><p><input type="submit" value="Cadastro"></p></form></center></html>', [DateTimeToStr(Now)]);
end;

procedure TWebModule1.WebModule1action2Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  sNome             := Request.QueryFields.Values['NOME'];
  sEndereco         := Request.QueryFields.Values['ENDERECO'];
  Response.Content  := PageProducer2.Content;
end;

procedure TWebModule1.PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if (TagString = 'NOME') then
    ReplaceText := sNome
  else if (TagString = 'ENDERECO') then
    ReplaceText := sEndereco;
end;

end.
